/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.brush_shapes;

import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.brush_shapes.FlatDiskBrushShape;
import com.moulberry.axiom.utils.Box;

public interface BiconeBrushShape
extends BrushShape {
    public static BrushShape create(int radius, int height) {
        if (height <= 0) {
            return FlatDiskBrushShape.create(radius);
        }
        return new SimpleBiconeBrushShape(radius, height);
    }

    public static final class SimpleBiconeBrushShape
    implements BiconeBrushShape {
        private final float invMaxRadiusSq;
        private final float invHeight;
        private final Box boundingBox;

        public SimpleBiconeBrushShape(int radius, int height) {
            this.invMaxRadiusSq = 1.0f / (((float)radius + 0.5f) * ((float)radius + 0.5f));
            this.invHeight = 1.0f / (float)height;
            this.boundingBox = new Box(-radius, -height, -radius, radius, height, radius);
        }

        @Override
        public Box boundingBox() {
            return this.boundingBox;
        }

        @Override
        public boolean isInsideShape(int x, int y, int z) {
            float rhs = 1.0f - (float)Math.abs(y) * this.invHeight;
            if (rhs < 0.0f) {
                return false;
            }
            return (float)(x * x + z * z) * this.invMaxRadiusSq <= rhs * rhs;
        }

        @Override
        public float distanceSq(int x, int y, int z) {
            float distance = this.distance(x, y, z);
            return distance * distance;
        }

        @Override
        public float distance(int x, int y, int z) {
            return (float)Math.abs(y) + (float)Math.sqrt(x * x + z * z);
        }

        @Override
        public float sdfSq(int x, int y, int z) {
            float sdf = this.sdf(x, y, z);
            return sdf * sdf;
        }

        @Override
        public float sdf(int x, int y, int z) {
            return (float)Math.abs(y) * this.invHeight + (float)Math.sqrt((float)(x * x + z * z) * this.invMaxRadiusSq);
        }
    }
}

